/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.controleurs;

import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionControleur;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.modele.objets.Cle;
import fr.asip.cps3.exemple.modele.objets.Objet;
import fr.asip.cps3.exemple.modele.objets.Session;
import fr.asip.cps3.exemple.modele.objets.Slot;
import fr.asip.cps3.exemple.modele.objets.Token;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general.InfoLibrairie;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general.InitialiserLibrairie;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general.TerminerLibrairie;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.generationaleatoire.GenerationNormale;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.AfficheAtttributObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.CopierObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.SupprimerObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.objets.TailleObjet;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.Deconnecter;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.FermerSession;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.FermerToutesLesSessions;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.InfoSession;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions.OuvrirSession;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.AttenteEvenementSlot;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.InfoAlgo;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.InfoSlot;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.InfoToken;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.ListerAlgo;
import fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes.ListerSlots;
import fr.asip.cps3.exemple.modele.traitements.specifiques.AssistantAuthentification;
import fr.asip.cps3.exemple.modele.traitements.specifiques.AuthentificationApresRetraitCarte;
import fr.asip.cps3.exemple.modele.traitements.specifiques.AuthentificationApresRetraitLecteur;
import fr.asip.cps3.exemple.modele.traitements.specifiques.EtatConnexionCarte;
import fr.asip.cps3.exemple.modele.traitements.specifiques.EtatSaisieCodePorteur;
import fr.asip.cps3.exemple.modele.traitements.specifiques.LectureObjetDonneesApplicatives;
import fr.asip.cps3.exemple.modele.traitements.specifiques.ModificationObjetDonneesApplicatives;
import fr.asip.cps3.exemple.modele.traitements.specifiques.RecyclageCodePorteur;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import fr.asip.cps3.exemple.vues.menus.ItemMenu;
import fr.asip.cps3.exemple.vues.menus.ItemMenuAlgo;
import fr.asip.cps3.exemple.vues.menus.ItemMenuCle;
import fr.asip.cps3.exemple.vues.menus.ItemMenuObjet;
import fr.asip.cps3.exemple.vues.menus.ItemMenuSession;
import fr.asip.cps3.exemple.vues.menus.ItemMenuSlot;
import fr.asip.cps3.exemple.vues.menus.ItemMenuToken;
import fr.asip.cps3.exemple.vues.menus.Menu;
import fr.asip.cps3.exemple.vues.menus.MenuAlgo;
import fr.asip.cps3.exemple.vues.menus.MenuToken;
import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class MenuControleur {
    private static Logger log = Logger.getLogger(MenuControleur.class);

    public static void executeOperation(Application application, ItemMenu itemMenu) {
        if (application != null && itemMenu != null && itemMenu.getId() != null) {
            try {
                if (itemMenu.getId().startsWith("0,0")) {
                    MenuControleur.executeOperationP11General(application, itemMenu);
                } else if (itemMenu.getId().startsWith("0,1")) {
                    MenuControleur.executeOperationP11SlotEtCartes(application, itemMenu);
                } else if (itemMenu.getId().startsWith("0,2")) {
                    MenuControleur.executeOperationP11Sessions(application, itemMenu);
                } else if (itemMenu.getId().startsWith("0,3")) {
                    MenuControleur.executeOperationP11Objets(application, itemMenu);
                } else if (itemMenu.getId().startsWith("0,4")) {
                    MenuControleur.executeOperationP11Empreintes(application, itemMenu);
                } else if (itemMenu.getId().startsWith("0,5")) {
                    MenuControleur.executeOperationP11Signatures(application, itemMenu);
                } else if (itemMenu.getId().startsWith("0,6")) {
                    MenuControleur.executeOperationP11Verification(application, itemMenu);
                } else if (itemMenu.getId().startsWith("0,7")) {
                    MenuControleur.executeOperationP11Generation(application, itemMenu);
                } else if (itemMenu.getId().startsWith("2")) {
                    MenuControleur.executeChangementSession(application, itemMenu);
                } else if (itemMenu.getId().equalsIgnoreCase("1,0,0")) {
                    MenuControleur.executeTraitementSpecifiqueEtatConnexionCarte(application, itemMenu);
                } else if (itemMenu.getId().equalsIgnoreCase("1,0,1")) {
                    MenuControleur.executeTraitementSpecifiqueAssistantAuthentification(application, itemMenu);
                } else if (itemMenu.getId().equalsIgnoreCase("1,1,0")) {
                    MenuControleur.executeTraitementSpecifiqueEtatSaisieCodePorteur(application, itemMenu);
                } else if (itemMenu.getId().equalsIgnoreCase("1,1,1")) {
                    MenuControleur.executeTraitementSpecifiqueRecyclageCodePorteur(application);
                } else if (itemMenu.getId().equalsIgnoreCase("1,0,2")) {
                    MenuControleur.executeTraitementSpecifiqueAuthentificationApresRetraitCarte(application);
                } else if (itemMenu.getId().equalsIgnoreCase("1,0,3")) {
                    MenuControleur.executeTraitementSpecifiqueAuthentificationApresRetraitLecteur(application);
                } else if (itemMenu.getId().equalsIgnoreCase("1,2,0")) {
                    MenuControleur.executeTraitementSpecifiqueLectureObjetDonneesApplicatives(application);
                } else if (itemMenu.getId().equalsIgnoreCase("1,2,1")) {
                    MenuControleur.executeTraitementSpecifiqueModificationObjetDonneesApplicatives(application);
                }
            }
            catch (ExceptionProgrammeExemple exceptionProgrammeExemple) {
                application.notifieException(exceptionProgrammeExemple);
            }
            catch (Throwable throwable) {
                log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
                application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
            }
        } else {
            log.error((Object)"L'application et/ou l'item clique est nul");
            if (application != null) {
                application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
            }
        }
    }

    private static void executeOperationP11General(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        if ("0,0,0".equalsIgnoreCase(itemMenu.getId())) {
            resultat = InitialiserLibrairie.traitementP11(application.getLibrairieP11());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && (resultat.getCodeRetourStr().startsWith("CKR_OK") || resultat.getCodeRetourStr().startsWith("CKR_CRYPTOKI_ALREADY_INITIALIZED"))) {
                MenuControleur.refresh(application, itemMenu.getId());
                application.declencheMAJMenus();
            }
        } else if ("0,0,1".equalsIgnoreCase(itemMenu.getId())) {
            resultat = TerminerLibrairie.traitementP11(application.getLibrairieP11());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                application.supprimeTousLesElementsEnCours();
                MenuControleur.refresh(application, itemMenu.getId());
                application.declencheMAJMenus();
            }
        } else if ("0,0,2".equalsIgnoreCase(itemMenu.getId()) && (resultat = InfoLibrairie.traitementP11(application.getLibrairieP11())) != null) {
            application.declencheAffichageResultat(resultat);
        }
    }

    private static void executeOperationP11SlotEtCartes(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple, PKCS11Exception {
        Resultat resultat = null;
        if ("0,1,0,1".equalsIgnoreCase(itemMenu.getId())) {
            resultat = ListerSlots.traitementP11(application.getLibrairieP11(), true);
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {
                application.supprimeTousLesElementsEnCours();
                application.ajouteLesSlots(resultat.getObjets(), true);
                MenuControleur.refresh(application, itemMenu.getId());
                application.declencheMAJMenus();
            }
        } else if ("0,1,0,0".equalsIgnoreCase(itemMenu.getId())) {
            resultat = ListerSlots.traitementP11(application.getLibrairieP11(), false);
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {
                application.supprimeTousLesElementsEnCours();
                application.ajouteLesSlots(resultat.getObjets(), false);
                MenuControleur.refresh(application, itemMenu.getId());
                application.declencheMAJMenus();
            }
        } else if (itemMenu.getId().startsWith("0,1,1")) {
            resultat = InfoSlot.traitementP11(application.getLibrairieP11(), ((ItemMenuSlot)itemMenu).getSlot().getIdSlot());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                MenuControleur.refresh(application, "0,1,1");
                application.declencheMAJMenus();
            }
        } else if (itemMenu.getId().startsWith("0,1,2")) {
            resultat = InfoToken.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)itemMenu).getToken().getIdSlotToken());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
        } else if ("0,1,3,0".equalsIgnoreCase(itemMenu.getId())) {
            resultat = AttenteEvenementSlot.traitementP11(application.getLibrairieP11(), true);
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
        } else if ("0,1,3,1".equalsIgnoreCase(itemMenu.getId())) {
            resultat = AttenteEvenementSlot.traitementP11(application.getLibrairieP11(), false);
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
        } else if (itemMenu.getId().startsWith("0,1,4")) {
            resultat = ListerAlgo.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)itemMenu).getToken().getIdSlotToken());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {
                application.supprimeTousLesAlgo(((ItemMenuToken)itemMenu).getToken().getNumeroSerie());
                application.ajouteLesAlgo(((ItemMenuToken)itemMenu).getToken(), resultat.getObjets());
                MenuControleur.refresh(application, "0,1,4");
                application.declencheMAJMenus();
            }
        } else if (itemMenu.getId().startsWith("0,1,5")) {
            resultat = InfoAlgo.traitementP11(application.getLibrairieP11(), ((ItemMenuAlgo)itemMenu).getAlgo().getIdSlotToken(), ((ItemMenuAlgo)itemMenu).getAlgo().getIdAlgo());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
        } else if (itemMenu.getId().equalsIgnoreCase("0,1,6")) {
            application.declencheAffichageEcran(3);
        } else if (itemMenu.getId().equalsIgnoreCase("0,1,7")) {
            application.declencheAffichageEcran(4);
        }
    }

    private static void executeOperationP11Sessions(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        if (itemMenu.getId().startsWith("0,2,0,1")) {
            resultat = OuvrirSession.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)itemMenu).getToken().getIdSlotToken(), true);
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {
                application.ajouteLaSession(((ItemMenuToken)itemMenu).getToken(), (Long)resultat.getObjets().get(0));
                MenuControleur.refresh(application, "0,2,0,1");
                application.declencheMAJMenus();
            }
        } else if (itemMenu.getId().startsWith("0,2,0,0")) {
            resultat = OuvrirSession.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)itemMenu).getToken().getIdSlotToken(), false);
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK") && resultat.getObjets() != null && resultat.getObjets().size() > 0) {
                application.ajouteLaSession(((ItemMenuToken)itemMenu).getToken(), (Long)resultat.getObjets().get(0));
                MenuControleur.refresh(application, "0,2,0,0");
                application.declencheMAJMenus();
            }
        } else if (itemMenu.getId().equalsIgnoreCase("0,2,1")) {
            if (application.getSessionCourante() != null) {
                resultat = InfoSession.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession());
            } else {
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de recuperation d'information sur la session : Il n'y a pas de session en cours");
                application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
            }
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
        } else if (itemMenu.getId().startsWith("0,2,2")) {
            resultat = FermerSession.traitementP11(application.getLibrairieP11(), ((ItemMenuSession)itemMenu).getSession().getIdSession());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                application.supprimeLaSession(((ItemMenuSession)itemMenu).getSession().getIdToken(), ((ItemMenuSession)itemMenu).getSession());
                if (application.nbSessionsActives() == 0) {
                    application.setSessionCourante(null);
                }
                MenuControleur.refresh(application, "0,2,2");
                application.declencheMAJMenus();
            }
        } else if (itemMenu.getId().startsWith("0,2,3")) {
            resultat = FermerToutesLesSessions.traitementP11(application.getLibrairieP11(), ((ItemMenuToken)itemMenu).getToken().getIdSlotToken());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                application.supprimeToutesLesSessions(((ItemMenuToken)itemMenu).getToken());
                if (application.nbSessionsActives() == 0) {
                    application.setSessionCourante(null);
                }
                MenuControleur.refresh(application, "0,2,3");
                application.declencheMAJMenus();
            }
        } else if (itemMenu.getId().equalsIgnoreCase("0,2,4,0")) {
            application.declencheAffichageEcran(2);
        } else if (itemMenu.getId().equalsIgnoreCase("0,2,4,1")) {
            application.declencheAffichageEcran(1);
        } else if (itemMenu.getId().equalsIgnoreCase("0,2,5") && application.getSessionCourante() != null) {
            resultat = Deconnecter.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession());
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
            }
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                application.getSessionCourante().chargeInfo(application.getLibrairieP11());
                MenuControleur.refresh(application, "0,2,5");
                application.declencheMAJMenus();
            }
        }
    }

    private static void executeOperationP11Objets(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        if (itemMenu.getId().startsWith("0,3,0")) {
            if (itemMenu.getId().equalsIgnoreCase("0,3,0,0,0")) {
                application.declencheAffichageEcran(12, null);
            } else if (itemMenu.getId().startsWith("0,3,0,2,0")) {
                Objet objet = ((ItemMenuObjet)itemMenu).getObjet();
                if (objet != null && application.getSessionCourante() != null) {
                    resultat = SupprimerObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                        TraitementsUtil.rechercheObjets(application, 4, objet.getLibelle(), false);
                    }
                    application.declencheMAJMenus();
                } else {
                    log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de suppression de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
                    application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
                }
            } else if (itemMenu.getId().startsWith("0,3,0,1,0")) {
                Objet objet = ((ItemMenuObjet)itemMenu).getObjet();
                if (objet != null && application.getSessionCourante() != null) {
                    resultat = CopierObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                        TraitementsUtil.rechercheObjets(application, 4, null, false);
                    }
                    application.declencheMAJMenus();
                } else {
                    log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de copie de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
                    application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
                }
            } else if (itemMenu.getId().startsWith("0,3,0,3,0")) {
                Objet objet = ((ItemMenuObjet)itemMenu).getObjet();
                if (objet != null && application.getSessionCourante() != null) {
                    resultat = TailleObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    application.declencheMAJMenus();
                } else {
                    log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation d'obtention de la taille de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
                    application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
                }
            } else if (itemMenu.getId().startsWith("0,3,0,4,0")) {
                Objet objet = ((ItemMenuObjet)itemMenu).getObjet();
                if (objet != null && application.getSessionCourante() != null) {
                    resultat = AfficheAtttributObjet.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession(), objet.getIdObjet(), objet.getLibelle());
                    if (resultat != null) {
                        application.declencheAffichageResultat(resultat);
                    }
                    application.declencheMAJMenus();
                } else {
                    log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation d'obtention de la valeur d'un l'attribut de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
                    application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
                }
            } else if (itemMenu.getId().startsWith("0,3,0,5,0")) {
                Objet objet = ((ItemMenuObjet)itemMenu).getObjet();
                if (objet != null && application.getSessionCourante() != null) {
                    application.declencheAffichageEcran(13, objet);
                } else {
                    log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de modification de la valeur d'un l'attribut de l'objet : L'objet vaut null et/ou Il n'y a pas de session en cours");
                    application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
                }
            }
        } else if (itemMenu.getId().startsWith("0,3,1")) {
            int n = 0;
            String string = null;
            if (itemMenu.getId().equalsIgnoreCase("0,3,1,0")) {
                n = 1;
            } else if (itemMenu.getId().equalsIgnoreCase("0,3,1,1")) {
                n = 2;
            } else if (itemMenu.getId().equalsIgnoreCase("0,3,1,2")) {
                n = 3;
            }
            if (itemMenu.getId().equalsIgnoreCase("0,3,1,3")) {
                n = 4;
                application.declencheAffichageEcran(14, null);
            }
            if (!itemMenu.getId().equalsIgnoreCase("0,3,1,3")) {
                resultat = TraitementsUtil.rechercheObjets(application, n, string, true);
            }
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
                application.declencheMAJMenus();
            }
        }
    }

    private static void executeOperationP11Empreintes(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        if (itemMenu.getId().startsWith("0,4,0")) {
            application.declencheAffichageEcran(6, ((ItemMenuAlgo)itemMenu).getAlgo());
        } else if (itemMenu.getId().startsWith("0,4,1")) {
            application.declencheAffichageEcran(7, ((ItemMenuAlgo)itemMenu).getAlgo());
        }
    }

    private static void executeOperationP11Signatures(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Vector<Object> vector = new Vector<Object>();
        ItemMenuCle itemMenuCle = (ItemMenuCle)itemMenu;
        MenuAlgo menuAlgo = (MenuAlgo)application.getMenu(itemMenuCle.getIdParent());
        if (menuAlgo != null && menuAlgo.getAlgo() != null && itemMenuCle != null && itemMenuCle.getCle() != null) {
            vector.add(menuAlgo.getAlgo());
            vector.add(itemMenuCle.getCle());
            if (itemMenu.getId().startsWith("0,5,0")) {
                application.declencheAffichageEcran(8, vector);
            } else if (itemMenu.getId().startsWith("0,5,1")) {
                application.declencheAffichageEcran(9, vector);
            }
        } else {
            log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la signature : Le couple algo/cl\u00e9 est incomplet");
            application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
        }
    }

    private static void executeOperationP11Verification(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Vector<Object> vector = new Vector<Object>();
        ItemMenuCle itemMenuCle = (ItemMenuCle)itemMenu;
        MenuAlgo menuAlgo = (MenuAlgo)application.getMenu(itemMenuCle.getIdParent());
        if (menuAlgo != null && menuAlgo.getAlgo() != null) {
            vector.add(menuAlgo.getAlgo());
            vector.add(itemMenuCle.getCle());
            if (itemMenu.getId().startsWith("0,6,0")) {
                if (application.getMessageSigne() != null && application.getSignatureMessage() != null) {
                    vector.add(application.getMessageSigne());
                    vector.add(application.getSignatureMessage());
                    application.declencheAffichageEcran(10, vector);
                } else {
                    log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la verification de signature du message : Le message signe/signature est incomplet");
                    application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
                }
            } else if (itemMenu.getId().startsWith("0,6,1")) {
                if (application.getFichierSigne() != null && application.getSignatureFichier() != null) {
                    vector.add(application.getFichierSigne());
                    vector.add(application.getSignatureFichier());
                    application.declencheAffichageEcran(11, vector);
                } else {
                    log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la verification de signature du fichier : Le fichier signe/signature est incomplet");
                    application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
                }
            }
        } else {
            log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'affichage de l'ecran de saisie pour la verification de signature : Le couple algo/cl\u00e9 est incomplet");
            application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
        }
    }

    private static void executeOperationP11Generation(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Resultat resultat = null;
        if (itemMenu.getId().equalsIgnoreCase("0,7,0")) {
            if (application.getSessionCourante() != null) {
                resultat = GenerationNormale.traitementP11(application.getLibrairieP11(), application.getSessionCourante().getIdSession());
            }
            if (resultat != null) {
                application.declencheAffichageResultat(resultat);
                application.declencheMAJMenus();
            } else {
                log.error((Object)"Une erreur inattendue est survenue lors de la tentative d'execution de l'operation de generation normale de nombre pseudo aleatoire : Il n'y a pas de session en cours");
                application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
            }
        } else if (itemMenu.getId().equalsIgnoreCase("0,7,1")) {
            application.declencheAffichageEcran(5);
        }
    }

    private static void executeChangementSession(Application application, ItemMenu itemMenu) {
        if (application.getSessionCourante() != null) {
            application.setSessionCourante(((ItemMenuSession)itemMenu).getSession());
            MenuControleur.refresh(application, itemMenu.getId());
            application.declencheMAJMenus();
        } else {
            log.error((Object)"Une erreur inattendue est survenue lors de la tentative de changement de session : Il n'y a pas de session en cours");
            application.notifieException(new ExceptionControleur(303, "Une erreur inattendue est survenue"));
        }
    }

    private static void executeTraitementSpecifiqueEtatConnexionCarte(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Resultat resultat = EtatConnexionCarte.traitement(application.getTraitementsSpecifiques());
        if (resultat != null) {
            application.declencheAffichageResultat(resultat);
        }
        if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
            MenuControleur.refresh(application, itemMenu.getId());
        }
    }

    private static void executeTraitementSpecifiqueAssistantAuthentification(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Resultat resultat = AssistantAuthentification.traitement(application.getTraitementsSpecifiques());
        if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE")) {
            MenuControleur.executeTraitementSpecifiqueRecyclageCodePorteur(application);
        } else if (resultat != null) {
            application.declencheAffichageResultat(resultat);
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                MenuControleur.refresh(application, itemMenu.getId());
            }
        }
    }

    private static void executeTraitementSpecifiqueEtatSaisieCodePorteur(Application application, ItemMenu itemMenu) throws ExceptionProgrammeExemple {
        Resultat resultat = EtatSaisieCodePorteur.traitement(application.getTraitementsSpecifiques());
        if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE")) {
            MenuControleur.executeTraitementSpecifiqueRecyclageCodePorteur(application);
        } else if (resultat != null) {
            application.declencheAffichageResultat(resultat);
            if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_OK")) {
                MenuControleur.refresh(application, itemMenu.getId());
            }
        }
    }

    private static void executeTraitementSpecifiqueRecyclageCodePorteur(Application application) throws ExceptionProgrammeExemple {
        Resultat resultat = RecyclageCodePorteur.traitement(application.getTraitementsSpecifiques());
        if (resultat != null) {
            application.declencheAffichageResultat(resultat);
        }
    }

    private static void executeTraitementSpecifiqueAuthentificationApresRetraitCarte(Application application) throws ExceptionProgrammeExemple {
        Resultat resultat = AuthentificationApresRetraitCarte.traitement(application.getTraitementsSpecifiques());
        if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE")) {
            MenuControleur.executeTraitementSpecifiqueRecyclageCodePorteur(application);
        } else if (resultat != null) {
            application.declencheAffichageResultat(resultat);
        }
    }

    private static void executeTraitementSpecifiqueAuthentificationApresRetraitLecteur(Application application) throws ExceptionProgrammeExemple {
        Resultat resultat = AuthentificationApresRetraitLecteur.traitement(application.getTraitementsSpecifiques());
        if (resultat != null && resultat.getCodeRetourStr() != null && resultat.getCodeRetourStr().startsWith("CKR_DEMANDE_RECYCLAGE")) {
            MenuControleur.executeTraitementSpecifiqueRecyclageCodePorteur(application);
        } else if (resultat != null) {
            application.declencheAffichageResultat(resultat);
        }
    }

    private static void executeTraitementSpecifiqueLectureObjetDonneesApplicatives(Application application) throws ExceptionProgrammeExemple {
        Resultat resultat = LectureObjetDonneesApplicatives.traitement(application.getTraitementsSpecifiques());
        if (resultat != null) {
            application.declencheAffichageResultat(resultat);
        }
    }

    private static void executeTraitementSpecifiqueModificationObjetDonneesApplicatives(Application application) throws ExceptionProgrammeExemple {
        Resultat resultat = ModificationObjetDonneesApplicatives.traitement(application.getTraitementsSpecifiques());
        if (resultat != null) {
            application.declencheAffichageResultat(resultat);
        }
    }

    public static void refresh(Application application, String string) {
        if (application != null && application.getMenu() != null && application.getMenu().getItemsMenus() != null && application.getFichierProperties() != null) {
            String string2;
            HashMap<Long, String> hashMap = new HashMap<Long, String>();
            hashMap.put(0L, "ropublic");
            hashMap.put(1L, "rouser");
            hashMap.put(2L, "rwpublic");
            hashMap.put(3L, "rwuser");
            hashMap.put(4L, "rwso");
            application.getMenu().getItemsMenus().keySet();
            for (String object2 : application.getMenu().getItemsMenus().keySet()) {
                long l;
                Vector<String> vector;
                String[] stringArray;
                String string3;
                JMenuItem jMenuItem = application.getMenu().getItemsMenus().get(object2);
                if (jMenuItem instanceof ItemMenu && ((ItemMenu)jMenuItem).isActif() || jMenuItem instanceof Menu && ((Menu)jMenuItem).isActif()) {
                    if (application.getFichierProperties().getProperty(object2 + ".slot.dependant") != null && Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".slot.dependant")) && application.getSlots() != null && application.getSlots().size() == 0) {
                        application.getMenu().setItemMenuNonActif(object2);
                    } else if (application.getFichierProperties().getProperty(object2 + ".carte.dependant") != null && Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".carte.dependant")) && application.getTokens() != null && application.getTokens().size() == 0) {
                        application.getMenu().setItemMenuNonActif(object2);
                    } else if (application.getFichierProperties().getProperty(object2 + ".session.dependant") != null && Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".session.dependant")) && application.nbSessionsActives() == 0) {
                        application.getMenu().setItemMenuNonActif(object2);
                    } else if (application.getFichierProperties().getProperty(object2 + ".session.courante.dependant") != null && Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".session.courante.dependant"))) {
                        if (application.getSessionCourante() == null) {
                            application.getMenu().setItemMenuNonActif(object2);
                        } else if (application.getFichierProperties().getProperty(object2 + ".session.courante.dependant") != null && application.getFichierProperties().getProperty(object2 + ".session.type") != null && (string3 = application.getFichierProperties().getProperty(object2 + ".session.type")) != null) {
                            stringArray = string3.split("\\|");
                            vector = new Vector<String>(Arrays.asList(stringArray));
                            try {
                                l = application.getSessionCourante().getEtatSession();
                                if (!vector.contains(hashMap.get(new Long(l)))) {
                                    application.getMenu().setItemMenuNonActif(object2);
                                }
                            }
                            catch (ExceptionObjet exceptionObjet) {
                                // empty catch block
                            }
                        }
                    }
                }
                if ((!(jMenuItem instanceof ItemMenu) || ((ItemMenu)jMenuItem).isActif()) && (!(jMenuItem instanceof Menu) || ((Menu)jMenuItem).isActif())) continue;
                if (application.getFichierProperties().getProperty(object2 + ".slot.dependant") != null && Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".slot.dependant")) && application.getSlots() != null && application.getSlots().size() > 0) {
                    application.getMenu().setItemMenuActif(object2);
                    continue;
                }
                if (application.getFichierProperties().getProperty(object2 + ".carte.dependant") != null && Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".carte.dependant")) && application.getTokens() != null && application.getTokens().size() > 0) {
                    application.getMenu().setItemMenuActif(object2);
                    continue;
                }
                if (application.getFichierProperties().getProperty(object2 + ".session.dependant") != null && Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".session.dependant")) && application.nbSessionsActives() != 0) {
                    application.getMenu().setItemMenuActif(object2);
                    continue;
                }
                if (application.getFichierProperties().getProperty(object2 + ".session.courante.dependant") == null || !Boolean.parseBoolean(application.getFichierProperties().getProperty(object2 + ".session.courante.dependant")) || application.getSessionCourante() == null || application.getFichierProperties().getProperty(object2 + ".session.courante.dependant") == null || application.getFichierProperties().getProperty(object2 + ".session.type") == null || (string3 = application.getFichierProperties().getProperty(object2 + ".session.type")) == null) continue;
                stringArray = string3.split("\\|");
                vector = new Vector<String>(Arrays.asList(stringArray));
                try {
                    l = application.getSessionCourante().getEtatSession();
                    if (!vector.contains(hashMap.get(new Long(l)))) continue;
                    application.getMenu().setItemMenuActif(object2);
                }
                catch (ExceptionObjet exceptionObjet) {}
            }
            String string3 = application.getFichierProperties().getProperty(string + ".desactive");
            if (string3 != null) {
                String[] stringArray = string3.split("\\|");
                for (int i = 0; i < stringArray.length; ++i) {
                    application.getMenu().setItemMenuNonActif(stringArray[i]);
                }
            }
            if ((string2 = application.getFichierProperties().getProperty(string + ".active")) != null) {
                String[] stringArray = string2.split("\\|");
                for (int i = 0; i < stringArray.length; ++i) {
                    application.getMenu().setItemMenuActif(stringArray[i]);
                }
            }
        }
    }

    public static void deverrouille(Application application) {
        if (application != null && application.getMenu() != null && application.getMenu().getItemsMenus().values() != null) {
            for (JMenuItem jMenuItem : application.getMenu().getItemsMenus().values()) {
                jMenuItem.setEnabled(true);
            }
        }
    }

    public static void verrouille(Application application) {
        if (application != null && application.getMenu() != null && application.getMenu().getItemsMenus().values() != null) {
            for (JMenuItem jMenuItem : application.getMenu().getItemsMenus().values()) {
                if (jMenuItem instanceof ItemMenu) {
                    jMenuItem.setEnabled(((ItemMenu)jMenuItem).isActif());
                    continue;
                }
                if (!(jMenuItem instanceof Menu)) continue;
                jMenuItem.setEnabled(((Menu)jMenuItem).isActif());
            }
        }
    }

    public static void majMenusSlots(Application application) {
        if (application != null && application.getMenu() != null && application.getSlots() != null) {
            Vector<Slot> vector = application.getSlots();
            application.getMenu().supprimeContenuMenu("0,1,1");
            if (vector != null && vector.size() != 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    Slot slot = vector.get(i);
                    if (slot == null || application.getItemMenu("0,0,0") == null) continue;
                    ActionListener actionListener = application.getItemMenu("0,0,0").getActionEcouteur();
                    application.getMenu().ajouteItemMenu(new ItemMenuSlot(slot, "0,1,1", true, true, actionListener));
                }
            }
        }
    }

    public static void majMenusTokens(Application application) {
        try {
            if (application != null && application.getMenu() != null && application.getTokens() != null) {
                Vector<Token> vector = application.getTokens();
                application.getMenu().supprimeContenuMenu("0,1,2");
                application.getMenu().supprimeContenuMenu("0,1,4");
                application.getMenu().supprimeContenuMenu("0,1,5");
                application.getMenu().supprimeContenuMenu("0,2,0,0");
                application.getMenu().supprimeContenuMenu("0,2,0,1");
                application.getMenu().supprimeContenuMenu("0,2,3");
                application.getMenu().supprimeContenuMenu("0,4,0");
                application.getMenu().supprimeContenuMenu("0,4,1");
                application.getMenu().supprimeContenuMenu("0,5,0");
                application.getMenu().supprimeContenuMenu("0,5,1");
                application.getMenu().supprimeContenuMenu("0,6,0");
                application.getMenu().supprimeContenuMenu("0,6,1");
                if (vector.size() != 0) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Token token = vector.get(i);
                        if (token == null || application.getItemMenu("0,0,0") == null) continue;
                        ActionListener actionListener = application.getItemMenu("0,0,0").getActionEcouteur();
                        application.getMenu().ajouteItemMenu(new ItemMenuToken(token, "0,1,2", true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuToken(token, "0,1,4", true, true, actionListener));
                        application.getMenu().ajouteMenu(new MenuToken(token, "0,1,5", true, true));
                        application.getMenu().ajouteItemMenu(new ItemMenuToken(token, "0,2,0,0", true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuToken(token, "0,2,0,1", true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuToken(token, "0,2,3", true, true, actionListener));
                        MenuControleur.majMenusAlgo(application, token);
                        if (application.getSessionCourante() == null || application.getSessionCourante().getIdSlot() != token.getIdSlotToken()) continue;
                        MenuControleur.majMenusObjets(application, token);
                    }
                }
            }
        }
        catch (ExceptionObjet exceptionObjet) {
            application.notifieException(exceptionObjet);
        }
    }

    public static void majMenusAlgo(Application application, Token token) {
        try {
            if (application != null && token != null && application.getMenu() != null && application.getAlgo() != null && application.getAlgo().get(token.getNumeroSerie()) != null) {
                Vector<Algo> vector = application.getAlgo().get(token.getNumeroSerie());
                application.getMenu().supprimeContenuMenu("0,1,5," + Long.toString(token.getIdSlotToken()));
                if (vector.size() != 0) {
                    application.getMenu().setItemMenuActif("0,1,5," + Long.toString(token.getIdSlotToken()));
                    for (int i = 0; i < vector.size(); ++i) {
                        Algo algo = vector.get(i);
                        if (algo == null || application.getItemMenu("0,0,0") == null) continue;
                        ActionListener actionListener = application.getItemMenu("0,0,0").getActionEcouteur();
                        application.getMenu().ajouteItemMenu(new ItemMenuAlgo(algo, "0,1,5," + Long.toString(token.getIdSlotToken()), true, true, actionListener));
                        if (application.getSessionCourante() == null || token.getNumeroSerie() == null || !token.getNumeroSerie().equalsIgnoreCase(application.getSessionCourante().getIdToken())) continue;
                        if (algo.isRealiseCondensat()) {
                            application.getMenu().ajouteItemMenu(new ItemMenuAlgo(algo, "0,4,0", true, true, actionListener));
                            application.getMenu().ajouteItemMenu(new ItemMenuAlgo(algo, "0,4,1", true, true, actionListener));
                        }
                        if (algo.isRealiseSignature()) {
                            application.getMenu().ajouteMenu(new MenuAlgo(algo, "0,5,0", false, true));
                            application.getMenu().ajouteMenu(new MenuAlgo(algo, "0,5,1", false, true));
                            application.getMenu().supprimeContenuMenu("0,5,0," + Long.toString(algo.getIdAlgo()));
                            application.getMenu().supprimeContenuMenu("0,5,1," + Long.toString(algo.getIdAlgo()));
                        }
                        if (algo.isVerificationSignature()) {
                            application.getMenu().ajouteMenu(new MenuAlgo(algo, "0,6,0", false, true));
                            application.getMenu().ajouteMenu(new MenuAlgo(algo, "0,6,1", false, true));
                            application.getMenu().supprimeContenuMenu("0,6,0," + Long.toString(algo.getIdAlgo()));
                            application.getMenu().supprimeContenuMenu("0,6,1," + Long.toString(algo.getIdAlgo()));
                        }
                        if (!algo.isRealiseSignature() && !algo.isVerificationSignature()) continue;
                        MenuControleur.majMenusCles(application, algo, token.getNumeroSerie());
                    }
                }
            }
        }
        catch (ExceptionObjet exceptionObjet) {
            application.notifieException(exceptionObjet);
        }
    }

    public static void majMenusCles(Application application, Algo algo, String string) {
        try {
            if (application != null && algo != null && application.getMenu() != null && application.getClesPrivees() != null) {
                ActionListener actionListener;
                Cle cle;
                int n;
                Vector<Cle> vector = application.getClesPrivees().get(string);
                Vector<Cle> vector2 = application.getClesPubliques().get(string);
                if (vector != null && vector.size() != 0) {
                    if (algo.isRealiseSignature()) {
                        application.getMenu().setItemMenuActif("0,5,0," + Long.toString(algo.getIdAlgo()));
                        application.getMenu().setItemMenuActif("0,5,1," + Long.toString(algo.getIdAlgo()));
                        application.getMenu().setItemMenuActif("0,5,0," + Long.toString(algo.getIdAlgo()));
                        application.getMenu().setItemMenuActif("0,5,1," + Long.toString(algo.getIdAlgo()));
                    }
                    for (n = 0; n < vector.size(); ++n) {
                        cle = vector.get(n);
                        if (cle == null || application.getItemMenu("0,0,0") == null) continue;
                        actionListener = application.getItemMenu("0,0,0").getActionEcouteur();
                        if (application.getSessionCourante() == null || string == null || !string.equalsIgnoreCase(application.getSessionCourante().getIdToken()) || !algo.isRealiseSignature()) continue;
                        application.getMenu().ajouteItemMenu(new ItemMenuCle(cle, "0,5,0," + Long.toString(algo.getIdAlgo()), true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuCle(cle, "0,5,1," + Long.toString(algo.getIdAlgo()), true, true, actionListener));
                    }
                }
                if (vector2 != null && vector2.size() != 0) {
                    if (algo.isVerificationSignature()) {
                        application.getMenu().setItemMenuActif("0,6,0," + Long.toString(algo.getIdAlgo()));
                        application.getMenu().setItemMenuActif("0,6,1," + Long.toString(algo.getIdAlgo()));
                        application.getMenu().setItemMenuActif("0,6,0," + Long.toString(algo.getIdAlgo()));
                        application.getMenu().setItemMenuActif("0,6,1," + Long.toString(algo.getIdAlgo()));
                    }
                    for (n = 0; n < vector2.size(); ++n) {
                        cle = vector2.get(n);
                        if (cle == null || application.getItemMenu("0,0,0") == null) continue;
                        actionListener = application.getItemMenu("0,0,0").getActionEcouteur();
                        if (application.getSessionCourante() == null || string == null || !string.equalsIgnoreCase(application.getSessionCourante().getIdToken()) || !algo.isVerificationSignature()) continue;
                        application.getMenu().ajouteItemMenu(new ItemMenuCle(cle, "0,6,0," + Long.toString(algo.getIdAlgo()), true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuCle(cle, "0,6,1," + Long.toString(algo.getIdAlgo()), true, true, actionListener));
                    }
                }
            }
        }
        catch (ExceptionObjet exceptionObjet) {
            application.notifieException(exceptionObjet);
        }
    }

    public static void majMenusSessions(Application application) {
        if (application != null && application.getMenu() != null && application.getSessions() != null) {
            TreeMap<String, Vector<Session>> treeMap = application.getSessions();
            application.getMenu().supprimeContenuMenu("2");
            application.getMenu().supprimeContenuMenu("0,2,2");
            if (treeMap != null && application.getItemMenu("0,0,0") != null) {
                ActionListener actionListener = application.getItemMenu("0,0,0").getActionEcouteur();
                for (String string : treeMap.keySet()) {
                    if (string == null) continue;
                    Vector<Session> vector = treeMap.get(string);
                    Vector<Session> vector2 = new Vector<Session>();
                    if (vector != null) {
                        for (Session session : vector) {
                            boolean bl = true;
                            try {
                                session.chargeInfo(application.getLibrairieP11());
                            }
                            catch (ExceptionObjet exceptionObjet) {
                                if (exceptionObjet.getCause() != null && exceptionObjet.getCause() instanceof PKCS11Exception) {
                                    if ("0x000000B3".equalsIgnoreCase("0x" + Functions.toFullHexString((int)((int)((PKCS11Exception)exceptionObjet.getCause()).getErrorCode())))) {
                                        vector2.add(session);
                                        bl = false;
                                    }
                                }
                                application.notifieException(exceptionObjet);
                            }
                            if (!bl) continue;
                            if (application.getSessionCourante() == session) {
                                application.getMenu().ajouteItemMenu(new ItemMenuSession(session, "2", true, true, true, actionListener));
                                application.getMenu().ajouteItemMenu(new ItemMenuSession(session, "0,2,2", true, true, true, actionListener));
                                continue;
                            }
                            application.getMenu().ajouteItemMenu(new ItemMenuSession(session, "2", false, true, true, actionListener));
                            application.getMenu().ajouteItemMenu(new ItemMenuSession(session, "0,2,2", false, true, true, actionListener));
                        }
                    }
                    for (Session session : vector2) {
                        application.supprimeLaSession(session.getIdToken(), session);
                    }
                }
            }
        }
    }

    public static void majMenusObjets(Application application, Token token) {
        try {
            if (application != null && token != null && application.getMenu() != null && application.getObjets() != null && application.getObjets().get(token.getNumeroSerie()) != null) {
                Vector<Objet> vector = application.getObjets().get(token.getNumeroSerie());
                application.getMenu().supprimeContenuMenu("0,3,0,4,0");
                application.getMenu().supprimeContenuMenu("0,3,0,5,0");
                application.getMenu().supprimeContenuMenu("0,3,0,1,0");
                application.getMenu().supprimeContenuMenu("0,3,0,3,0");
                application.getMenu().supprimeContenuMenu("0,3,0,2,0");
                if (vector.size() != 0) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Objet objet = vector.get(i);
                        if (objet == null || application.getItemMenu("0,0,0") == null) continue;
                        ActionListener actionListener = application.getItemMenu("0,0,0").getActionEcouteur();
                        if (application.getSessionCourante() == null || token.getNumeroSerie() == null || !token.getNumeroSerie().equalsIgnoreCase(application.getSessionCourante().getIdToken())) continue;
                        application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet, "0,3,0,4,0", true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet, "0,3,0,5,0", true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet, "0,3,0,1,0", true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet, "0,3,0,3,0", true, true, actionListener));
                        application.getMenu().ajouteItemMenu(new ItemMenuObjet(objet, "0,3,0,2,0", true, true, actionListener));
                    }
                }
            }
        }
        catch (ExceptionObjet exceptionObjet) {
            application.notifieException(exceptionObjet);
        }
    }

    public static void majMenus(Application application) {
        MenuControleur.majMenusSlots(application);
        MenuControleur.majMenusTokens(application);
        MenuControleur.majMenusSessions(application);
    }
}

